;----------------------------------------------------------------------------
; TurboGrafx CD
; Mednafen 0.9.15
; by BBB
; 1.1
;
; Notes:
; This module assumes you have the bios in your mednafen directory.
; It seems that having your CD's in a subdirectory automatically checked
; so we dont have to add the subdirectory in the run command. 
;
; Below are some basic params you can change, there are many other params
; located in the mednafen documentation that you can add if needed.
;
; Some people experience screen flickering or black screen
; and mednafen will not stay in fullscreen, you can changed 
; vDriver below to -vdriver sdl and it will possibly fix the issue.
;
; There is no error checking if mednafen fails, so if you try to launch
; your game and nothing happens, then check the stdout.txt in your mednafen
; installation directory to see what went wrong.
;
; To remap your keys, start a game then press alt + shift + 1 to enter
; the key configuration.  Also see mednafen.cfg to change other keys such
; as the exit key.
;
;----------------------------------------------------------------------------

;Params
fullScreen := "-fs 1" ; 0 or 1
stretchFullscreen := "-pce.stretch 1" ; 0 or 1
vDriver := "-vdriver opengl" ; opengl or sdl
xRes := "-pce.xres 1024"
yRes := "-pce.yres 768"

params = %fullScreen% %stretchFullscreen% %vDriver% %xRes% %yRes% 

Run, "%EmuPath%%Executable%" %params% "%romPath%%romName%%romExtension%"

Process, WaitClose, %Executable%

ExitApp
           
CloseProcess:
return